#version 330
#extension GL_EXT_gpu_shader4 : enable
//Tunnel hiddingMod01.fsh  by  rodgzilla
//https://www.shadertoy.com/view/wssGzS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MIN_DIST 0.01
#define MAX_DIST 100.
#define MAX_STEPS 100
#define SURF_SHIFT 0.1
#define FOV_PARAM 2.
#define FORWARD_SPEED 10.

vec3 palette(float t) {
    vec3 a = vec3(0.5);
    vec3 b = vec3(0.5);
    vec3 c = vec3(1, 1, 0.5);
    vec3 d = vec3(0.8, 0.9, 0.3);
 	return (a + b * cos(6.28138 * (c * t + d)));
}

float cubicPulse(float c, float w, float x) {
	x = abs(x - c);
    if (x > w) return 0.;
    x /= w;
    
    return 1. - x * x * (3. - 2. * x);
}

mat2 rot2d(float a) {
    float c = cos(a);
    float s = sin(a);
    
    return mat2(c, s, -s, c);
}

float GetDistSphere(vec3 p, vec4 sphere){
    return length(sphere.xyz - p) - sphere.w;
}

float GetDistSphereRep(vec3 p, vec3 c, vec4 sphere) {
    vec3 q = mod(p, c) - 0.5 * c;
    
    return GetDistSphere(q, sphere);
}

float GetDistPlane(vec3 p) {
	float dist = 2.5 + cubicPulse(0.85, 0.15, fract(iTime / 5.)) * 100.; 
    float d = p.y + dist; // floor
	d = min(d, dist - p.y); // roof
    d = min(d, p.x + dist); // left
    d = min(d, dist - p.x); // right
    
    
    return d;
}

float GetDist(vec3 p){
    p.xy *= rot2d(p.z / 100.);
//    p.xy *= rot2d(sin(iTime) * sin(p.z));
//    p.xy *= rot2d(.4 * sin(4. * iTime) * sin(0.5 * p.z));
    vec4 sphere = vec4(0, 0, 3., 1.);
    vec3 rep = vec3(5., 5., 5.);
    float dSphere = GetDistSphereRep(p, rep, sphere);
    float dPlane = GetDistPlane(p);
        
    return min(dSphere, dPlane);
}

float RayMarch(vec3 ro, vec3 rd) {
    float d = 0.;
    
    for (int i = 0; i < MAX_STEPS; i++) {
        vec3 p = ro + d * rd;
        float dScene = GetDist(p);
        d += dScene;
        
        if (dScene < MIN_DIST || dScene > MAX_DIST) {
            break;
        }
    }
    
    return d;
}

vec3 GetNormal(vec3 p) {
    vec2 e = vec2(0.01, 0);
    
    vec3 n = GetDist(p) - vec3(
        GetDist(p - e.xyy),
        GetDist(p - e.yxy),
        GetDist(p - e.yyx)
    );
    
    return normalize(n);
}

float GetLight(vec3 p) {
    vec3 light = vec3(0, 0, FORWARD_SPEED * iTime + 1.);
//    light.xz = (light.xz - vec2(0, 4)) * rot2d(iTime) + vec2(0, 4);
    vec3 toLight = light - p;
    vec3 n = GetNormal(p);
    float dif = dot(n, normalize(toLight));
    float d = RayMarch(p + SURF_SHIFT * n, normalize(toLight));
    
    if (d < length(toLight)) {
        dif *= .1;
    } 
    
    return dif;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy - 0.5 * iResolution.xy) / iResolution.y;
    uv *= FOV_PARAM;
	vec3 col = vec3(0);
//    vec3 ro = vec3(0);
    vec3 ro = vec3(0, 0, FORWARD_SPEED * iTime);
    vec3 rd = normalize(vec3(uv.x, uv.y, 1.));
	float d = RayMarch(ro, rd);
    vec3 p = ro + d * rd;
    float dif = GetLight(p);
    col = dif * palette(d / MAX_DIST);
    
    gl_FragColor = vec4(col,1.0);
}